/** @file   Size2D.cpp
 * @brief   Implementation of Size2D class.
 * @version $Revision: 1.1 $
 * @date    $Date: 2006/01/29 20:10:44 $
 * @author  Tomi Lamminsaari
 */

#include "Size2D.h"


namespace eng2d {

///
/// Constants, datatypes and static methods
/// ============================================================================




///
/// Constructors, destructor and operators
/// ============================================================================

/** Default constructor.
 */
Size2D::Size2D()
{
}



/** Constructor.
 */
Size2D::Size2D(int aWidth, int aHeight) :
  iWidth( aWidth ),
  iHeight( aHeight )
{
}


/** Destructor.
 */
Size2D::~Size2D()
{
}


/** Copy constructor.
 */
Size2D::Size2D( const Size2D& aAnother ) :
  iWidth( aAnother.iWidth ),
  iHeight( aAnother.iHeight )
{
}


/** Assignment operator.
 */
Size2D& Size2D::operator = ( const Size2D& aAnother )
{
  iWidth = aAnother.iWidth;
  iHeight = aAnother.iHeight;
  return *this;
}



///
/// Methods inhertited from the base class(es)
/// ============================================================================




///
/// New public methods
/// ============================================================================




///
/// Getter methods
/// ============================================================================




///
/// Protected and private methods
/// ============================================================================


};  // end of namespace
